using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;


namespace WindowsGame1
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class TablicaWynikow : Microsoft.Xna.Framework.DrawableGameComponent
    {
        int wynikGracza1;
        int wynikGracza2;
        Vector2 polozenieWyniku1;
        Vector2 polozenieWyniku2;
        SpriteFont font;
        SpriteBatch spriteBatch;

        public TablicaWynikow(Game game, SpriteFont font, Vector2 polozenieWyniku1, Vector2 polozenieWyniku2)
            : base(game)
        {
            this.font = font;
            this.polozenieWyniku1 = polozenieWyniku1;
            this.polozenieWyniku2 = polozenieWyniku2;
            spriteBatch = (SpriteBatch)Game.Services.GetService(typeof(SpriteBatch));
        }
        public override void Draw(GameTime gameTime)
        {
            spriteBatch.Begin();
            spriteBatch.DrawString(font, wynikGracza1.ToString(), polozenieWyniku1, Color.WhiteSmoke);
            spriteBatch.DrawString(font, wynikGracza2.ToString(), polozenieWyniku2, Color.WhiteSmoke);
            spriteBatch.End();
            base.Draw(gameTime);
        }
        public void DodajPunkt(int numerGracza)
        {
            if (numerGracza == 1)
                wynikGracza1++;
            if (numerGracza == 2)
                wynikGracza2++;
        }
    }
}